/***************************************************************************** 
                                                  COPYRIGHT (c) FREESCALE 2005   
                                                                             
File Name          :    $RCSfile: S12XECRGV1.h,v $                         
                                                                             
Current Revision :      $Revision: 1.0 $                                   
                                                                             
PURPOSE: header file for HCS12XE CRG block                                 
                                                                             
DESCRIPTION: Defines the Clocks and Reset Generator (inc pll) block as a   
             datastructure of type tCRG.                                                
                                                                             
UPDATE HISTORY                                                             
REV  AUTHOR      DATE       DESCRIPTION OF CHANGE                          
---  ------      --------    ---------------------                         
1.0  r32151      31/08/05   - Initial coding based on S12CRGV6.h.          
1.1  r32151      18/07/06   - renamed FM bits in PLLCTL register 

      *****************************************************************
      *File created by: Freescale East Kilbride MCD Applications Group*
      *****************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#ifndef S12XECRGV1_H         /*prevent duplicated includes */
#define S12XECRGV1_H

#include "S12_COMMON.h"

typedef union uSYNR
  {
  tU08   byte;
  struct
    {
    tU08 syndiv :6;      /* synthesizer bits, controls multiplication factor of PLL */
    tU08 vcofrq :2;      /* VCO adjustment */
    }bit;
  }tSYNR;

/*bit masks for SYNR */
#define VCOFRQ0  0x40  
#define VCOFRQ1  0x80  

typedef union uREFDV
  {
  tU08   byte;
  struct
    {
    tU08 refdiv :6;      /* allows finer granularity for pll ref freq  */
    tU08 reffrq :2;      /* reference adjustment */
    }bit;
  }tREFDV;

/*bit masks for REFDV */
#define REFFRQ0  0x40  
#define REFFRQ1  0x80  

typedef union uCRGFLG
  {
  tU08   byte;
  struct
    {
    tU08 scm     :1;    /*self clock mode ststus (1: limp-home clock active) */
    tU08 scmif   :1;    /*self clock mode interrupt flag */
    tU08 ilaf    :1;    /*ilegal address reset flag*/
    tU08 lock    :1;    /*lock status */
    tU08 lockif  :1;    /*lock interrupt flag */
    tU08 lvrf    :1;    /*low voltage reset flag*/
    tU08 porf    :1;    /*power on reset flag */
    tU08 rtif    :1;    /*real time interrupt flag */
    }bit;
  }tCRGFLG;

/*bit masks for CRGFLG */
#define SCM      0x01   
#define SCMIF    0x02
#define ILAF     0x04   
#define LOCK     0x08   
#define LOCKIF   0x10   
#define LVRF     0x20   
#define PORF     0x40   
#define RTIF     0x80

typedef union uCRGINT
  {
  tU08   byte;
  struct
    {
    tU08        :1;     /*not used*/
    tU08 scmie  :1;     /*self clock mode interrupt enable */
    tU08        :2;     /*not used*/
    tU08 lockie :1;     /*lock interrupt enable */
    tU08        :2;     /*not used */
    tU08 rtie   :1;     /*real time interrupt enable */
    }bit;
  }tCRGINT;

/*bit masks for CRGINT */
#define SCMIE   0x02 
#define LOCKIF  0x10 
#define RTIE    0x80


typedef union uCLKSEL
  {
  tU08   byte;
  struct
    {
    tU08 copwai   :1;      /*COP halts in wait */
    tU08 rtiwai   :1;      /*RTI halts in wait */
    tU08          :1;      /*not used */
    tU08 pllwai   :1;      /*PLL off in wait */
    tU08          :1;      /*not used */
    tU08 xclks    :1;      /*oscillator config status */
    tU08 pstp     :1;      /*pseudo stop mode enable */
    tU08 pllsel   :1;      /*pll select */
    }bit;
  }tCLKSEL;

/*bit masks for CRGINT */
#define COPWAI   0x01      
#define RTIWAI   0x02      
#define PLLWAI   0x08      
#define PSTP     0x40      
#define PLLSEL   0x80      

typedef union uPLLCTL
  {
  tU08   byte;
  struct
    {
    tU08 scme    :1;    /*self clock mode enable */
    tU08 pce     :1;    /*pseudo stop COP enable */
    tU08 pre     :1;    /*pseudo stop RTI enable */
    tU08 fstwkp  :1;    /*fast wake up from full-stop enable */
    tU08 fm      :2;    /* factory use only */
    tU08 pllon   :1;    /*phase lock loop on */
    tU08 cme     :1;    /*crystal monitor enable */
    }bit;
  }tPLLCTL;

/*bit masks for PLLCTL */
#define SCME   0x01  /*bit masks */
#define PCE    0x02
#define PRE    0x04
#define FSTWKP 0x08
#define FM0    0x10
#define FM1    0x20
#define PLLON  0x40
#define CME    0x80

typedef union uRTICTL
{
   tU08 byte;
   struct
    {
      tU08 rtimcs  :4;      /*modulus counter select */
      tU08 rtiprs  :3;      /*prescaler rate select */
      tU08 rtdec   :1;      /*decimal prescaler select*/
    }bit;
}tRTICTL;
  
/*bit masks for RTICTL */
#define RTR0   0x01  
#define RTR1   0x02
#define RTR2   0x04
#define RTR3   0x08
#define RTR4   0x10
#define RTR5   0x20
#define RTR6   0x40
#define RTDEC  0x80

typedef union uCOPCTL
{          
   tU08 byte;
   struct
    {
      tU08 cr      :3;      /*cop timer rate select */
      tU08         :2;      /*not used */
      tU08 wrtmask :1;      /*write mask for wcop & cr bits */
      tU08 rsbck   :1;      /*cop and rti stop in active bdm */
      tU08 wcop    :1;      /*window cop enable */
    }bit;
}tCOPCTL;

/*bit masks for COPCTL */
#define CR0     0x01  
#define CR1     0x02
#define CR2     0x04
#define WRTMASK 0x20
#define RSBCK   0x40
#define WCOP    0x80

typedef union uFORBYP   /* factory use only */      
  {
  tU08   byte;
  struct
    {
    tU08 tstsqu    :1;     
    tU08           :2;     
    tU08 scbyp     :1;
    tU08 fcforceen :1;
    tU08 xfcen     :1;
    tU08           :2;     
    }bit;
  }tFORBYP;

/*bit masks for FORBYP */
#define TSTSQU    0x01 
#define SCBYP     0x08
#define FCFORCEEN 0x10
#define XFCEN     0x20

typedef union uCTCTL   /* factory use only */   
  {
  tU08   byte;
  struct
    {
    tU08 pfd       :1;     
    tU08 pfu       :1;     
    tU08 ctce      :1;     
    tU08 pcs       :1;
    tU08 to        :1;
    tU08           :1;     
    tU08 sync      :1;
    tU08 pfe       :1;     
    }bit;
  }tCTCTL;

/*bit masks for FORBYP */
#define PFD        0x01 
#define PFU        0x02 
#define CTCE       0x04 
#define PCS        0x08 
#define TO         0x10 
#define SYNC       0x40
#define PFE        0x80


typedef struct          
  {
  volatile  tSYNR    synr;    /*synthesizer register */
  volatile  tREFDV   refdv;   /*reference divider register */
  volatile  tREG08   postdiv; /*output post divider register  */
  volatile  tCRGFLG  crgflg;  /*clock generator flags register */
  volatile  tCRGINT  crgint;  /*clock generator interrupt control register */
  volatile  tCLKSEL  clksel;  /*clock generator clock select register */
  volatile  tPLLCTL  pllctl;  /*pll control register */
  volatile  tREG08   rtictl;  /*rti control register */
  volatile  tCOPCTL  copctl;  /*cop control register */
  volatile  tFORBYP  forbyp;  /*crg force and bypass test register */
  volatile  tREG08   ctctl;   /*crg test control register */
  volatile  tREG08   armcop;  /*cop arming register (to reset write $55:$0AA) */
  }tCRG;

#endif /* S12XECRGV1_H */